/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.util.OptiFineHelper;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    public static void onFinishedLoading() {
        HashMap idToConfigs = new HashMap();
        ClientHandler.getConfigSets().forEach((type, modConfigs) -> modConfigs.forEach(modConfig -> {
            Map typeToConfigSet = idToConfigs.computeIfAbsent(modConfig.getModId(), s -> new HashMap());
            Set configSet = typeToConfigSet.computeIfAbsent(type, t -> new HashSet());
            configSet.add(modConfig);
        }));
        Configured.LOGGER.info("Creating config GUI factories...");
        ModList.get().forEachModContainer((modId, container) -> {
            List commonConfigFileEntries;
            if (container.getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY).isPresent()) {
                return;
            }
            Map typeToConfigSet = (Map)idToConfigs.get(modId);
            if (typeToConfigSet == null) {
                return;
            }
            Set clientConfigs = (Set)typeToConfigSet.get(ModConfig.Type.CLIENT);
            Set commonConfigs = (Set)typeToConfigSet.get(ModConfig.Type.COMMON);
            if (OptiFineHelper.isLoaded() && modId.equals("forge")) {
                Configured.LOGGER.info("Ignoring Forge's client config since OptiFine was detected");
                clientConfigs = null;
            }
            List clientConfigFileEntries = clientConfigs != null && clientConfigs.size() > 0 ? clientConfigs.stream().map(config -> new ConfigScreen.ConfigFileEntry(config.getSpec(), config.getSpec().getValues())).collect(Collectors.toList()) : null;
            List list = commonConfigFileEntries = commonConfigs != null && commonConfigs.size() > 0 ? commonConfigs.stream().map(config -> new ConfigScreen.ConfigFileEntry(config.getSpec(), config.getSpec().getValues())).collect(Collectors.toList()) : null;
            if (clientConfigFileEntries != null || commonConfigFileEntries != null) {
                Configured.LOGGER.info("Registering config factory for mod {} (client: {}, common: {})", modId, (Object)(clientConfigFileEntries != null ? 1 : 0), (Object)(commonConfigFileEntries != null ? 1 : 0));
                ResourceLocation background = AbstractGui.field_230663_f_;
                if (container.getModInfo() instanceof ModInfo) {
                    Optional optional;
                    String configBackground = (String)container.getModInfo().getModProperties().get("configuredBackground");
                    if (configBackground == null && (optional = ((ModInfo)container.getModInfo()).getConfigElement(new String[]{"configBackground"})).isPresent()) {
                        configBackground = (String)optional.get();
                    }
                    if (configBackground != null) {
                        background = new ResourceLocation(configBackground);
                    }
                }
                String displayName = container.getModInfo().getDisplayName();
                ResourceLocation finalBackground = background;
                container.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ConfigScreen((Screen)screen, displayName, clientConfigFileEntries, commonConfigFileEntries, finalBackground));
            }
        });
    }

    private static EnumMap<ModConfig.Type, Set<ModConfig>> getConfigSets() {
        return (EnumMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"configSets");
    }
}

